import { ModuleWithProviders } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';

import { AdminMenusComponent } from './admin-menus/admin-menus.component';
import { SpellCheckComponent } from './spellcheck/spellcheck.component';
import { LoggerComponent } from './logger/logger.component';
import { FhirSearchComponent } from './fhir-search/fhir-search.component';
import { FaqComponent } from './faq/faq.component'
import { HelpComponent } from './help/help.component'
import { ContactComponent } from './contact/contact.component'
import { SearchResultsComponent } from './search-results/search-results.component'
import { FhirResourceComponent } from './fhir-resource/fhir-resource.component'

const routes: Routes = [
  { path: 'menus', component: AdminMenusComponent },
  { path: 'logger', component: LoggerComponent },
  { path: 'spellcheck', component: SpellCheckComponent },
  { path: 'fhir', component: FhirSearchComponent },
  { path: 'faq', component: FaqComponent },
  { path: 'help', component: HelpComponent },
  { path: 'search', component: SearchResultsComponent },
  { path: 'contact', component: ContactComponent },
  { path: 'fhirresource', component: FhirResourceComponent }
];

export const routing: ModuleWithProviders = RouterModule.forChild(routes);
